%%
%Define our driving cycle
% Sch_Cycle=[0 0;10 0; 15 30; 20 30; 30 40; 40 40; 55 70;...
%   70 70; 80 30; 90 30; 100 0; 120 0];
% if (exist('fn') == 0)|(fn==0)
%    fn='Drive_Cycles\schedule_fu505.mat';
% else
%    fn=['Drive_Cycles\',fn];
% end
% [fn,pn]=uigetfile('Drive_Cycles\sch*.mat','Specify an Excel Schedule File Name',fn);
% name=[pn,fn];
% eval(['load ''',name,'''']);
%%
%%

%Vehicle Constants
Vehicle_Mass = 1633; %in kg (3600 pounds)
Tire_Radius = 0.406; %in meters (16 inches)

% Rear Differential Constants
Drive_Gear_Ratio = 3.73;
Half_Shaft_Inertia = 1.5e-3;  %kg*m^2
Drive_Shaft_Inertia = 0.02;   %kg*m^2
%%


%Battery Constants
Battery_VOC = 365; %Open circuit voltage in Volts.
Battery_Resistance = 0.4; %Charge and discharge resistance approximation in Ohms.
Battery_AH_Rating = 8; %Battery name plate Amp-Hour rating in AH.
Battery_SOC_Init = 0.7; %Battery initial state of charge.


Battery_Name = 'Battery Datal.xls'; 
Battery_PN = ['Component Data\',Battery_Name];
Charge_Resistance_map = xlsread(Battery_PN, 'Charge Resistance');
Discharge_Resistance_map = xlsread(Battery_PN, 'Discharge Resistance'); 
OCV_map = xlsread(Battery_PN, 'OCV'); 
SOC_Axis = xlsread(Battery_PN, 'SOC Axis'); 
R_Temp_Axis = xlsread(Battery_PN, 'R Temp Axis'); 
OCV_Temp_Axis = xlsread(Battery_PN, 'OCV Temp Axis'); 
%
%Motor Model Constants

Max_Motor_Torque = 240; % Nm
Motor_Inertia = 0.1; % kg*m^2
Motor_Name = 'Fantasy Motor_Data.xls'; 
Motor_PN = ['Component Data\',Motor_Name]; 
motor_max_torque = xlsread(Motor_PN,'Max_Torque');
motor_max_torque_rpm_axis =xlsread(Motor_PN,'Max_Torque_rpm_Axis');
motor_eff_map = xlsread(Motor_PN,'Eff_Data');
motor_eff_rpm_axis = xlsread(Motor_PN,'Motor_RPM_Axis');
motor_eff_current_axis = xlsread(Motor_PN,'Current_Axis');
%%


% Engine Model Constants
engine_inertia = 0.15;
engine_max_rpm = 4500;
engine_brake_torque = 10; %  Nm
Engine_Name = 'FantasyEngine_Data.xls';
Engine_PN = ['Component Data\',Engine_Name];
engine_rpm_axis = xlsread(Engine_PN,'Engine_RPM_Axis');
engine_throttle_axis = xlsread(Engine_PN,'Throttle_Axis');
engine_consumption_data = xlsread(Engine_PN,'Consumption_Data');
engine_torque_data = xlsread(Engine_PN,'Torque_Data');
engine_torque_data(1:end,1) = -engine_brake_torque;
Engine_Idle_Speed = 1000; %rpm

%%
%Controller Constants
Charging_Engine_rpm = 1800; %Constant engine rpm for charging.
SOC_Charge_On = 0.6; %Value of SOC where we start charging.
SOC_Charge_Off = 0.7; %Value of SOC where we stop charging.
Battery_SOC_No_Regen = 0.8; %Value of SOC where we do not allow regen braking.


Sample_Time = 0.01;
